/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.contentAssist;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.contentassist.ILexemeProvider;
import com.aptana.editor.common.contentassist.LexemeProvider;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.internal.contentAssist.PHPScopeScanner;
import com.aptana.editor.php.internal.contentAssist.PHPTokenType;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.rules.ITokenScanner;

public final class ParsingUtils {
    public static ILexemeProvider<PHPTokenType> createLexemeProvider(IDocument document, int offset) {
        if (offset == document.getLength() && offset > 0) {
            --offset;
        }
        return new LexemeProvider<PHPTokenType>(document, offset, (ITokenScanner)new PHPScopeScanner()){

            protected PHPTokenType getTypeFromData(Object data) {
                if (data != null) {
                    return new PHPTokenType(data.toString());
                }
                return new PHPTokenType("UNKNOWN_TOKEN");
            }
        };
    }

    public static ILexemeProvider<PHPTokenType> createLexemeProvider(IDocument document) {
        return new LexemeProvider<PHPTokenType>(document, (IRange)new Range(0, document.getLength() - 1), (ITokenScanner)new PHPScopeScanner()){

            protected PHPTokenType getTypeFromData(Object data) {
                if (data != null) {
                    return new PHPTokenType(data.toString());
                }
                return new PHPTokenType("UNKNOWN_TOKEN");
            }
        };
    }

    public static ILexemeProvider<PHPTokenType> createLexemeProvider(IDocument document, int start, int end) {
        if (end == document.getLength() && end > 0) {
            --end;
        }
        return new LexemeProvider<PHPTokenType>(document, (IRange)new Range(start, end), (ITokenScanner)new PHPScopeScanner()){

            protected PHPTokenType getTypeFromData(Object data) {
                if (data != null) {
                    return new PHPTokenType(data.toString());
                }
                return new PHPTokenType("UNKNOWN_TOKEN");
            }
        };
    }

    public static List<String> parseCallPath(ITypedRegion region, String content, int offset, String[] possibleReferenceOperators) {
        return ParsingUtils.parseCallPath(region, content, offset, possibleReferenceOperators, false, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> parseCallPath(ITypedRegion region, String content, int offset, String[] possibleReferenceOperators, boolean skipInitialSpaces, IDocument document) {
        try {
            String entry;
            if (region != null && document != null) {
                try {
                    ITypedRegion partition;
                    ITypedRegion prevRegion = null;
                    int rOffset = region.getOffset() - 1;
                    int totalLength = region.getLength();
                    while (rOffset > 0 && (partition = document.getPartition(rOffset)).getType().startsWith("__php_")) {
                        prevRegion = partition;
                        rOffset = prevRegion.getOffset() - 1;
                        totalLength += prevRegion.getLength();
                    }
                    if (prevRegion != null) {
                        region = new TypedRegion(prevRegion.getOffset(), totalLength, region.getType());
                    }
                }
                catch (BadLocationException e) {
                    IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error while parsing the call path", (Throwable)e);
                }
            }
            ArrayList<String> result = new ArrayList<String>();
            if (content.length() == 0) {
                result.add("");
                return result;
            }
            int currentPos = offset = ParsingUtils.fixOffset(content, offset);
            if (skipInitialSpaces) {
                ParsingUtils.skipWhiteSpaces(offset, content);
            }
            if ((entry = ParsingUtils.parseFunctionCall(region, content, currentPos, false)) == null) {
                entry = ParsingUtils.parseName(region, content, currentPos, false);
            }
            currentPos -= entry.length();
            result.add(entry);
            while (true) {
                String operator;
                if ((operator = ParsingUtils.parseReferenceOperator(region, possibleReferenceOperators, currentPos = ParsingUtils.skipWhiteSpaces(currentPos, content), content)) == null) {
                    return result;
                }
                currentPos -= operator.length();
                entry = ParsingUtils.parseFunctionCall(region, content, currentPos = ParsingUtils.skipWhiteSpaces(currentPos, content), false);
                if (entry == null) {
                    entry = ParsingUtils.parseName(region, content, currentPos, false);
                }
                if (entry == null || entry.length() == 0) {
                    return null;
                }
                currentPos -= entry.length();
                result.add(0, operator);
                result.add(0, entry);
            }
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static int fixOffset(String content, int offset) {
        int originalOffset = offset;
        char ch = content.charAt(offset);
        if (ch == '(') {
            int openings = 1;
            int start = offset + 1;
            int searchLimit = Math.min(start + 500, content.length());
            int c = start;
            while (c < searchLimit) {
                ++offset;
                ch = content.charAt(c);
                if (ch == '(') {
                    ++openings;
                } else if (ch == ')') {
                    --openings;
                }
                if (openings == 0) break;
                ++c;
            }
            if (openings != 0) {
                return originalOffset;
            }
        }
        return offset;
    }

    public static boolean isFunctionCall(String call) {
        return call.indexOf(40) >= 1;
    }

    public static String getFunctionNameFromCall(String call) {
        int openingBracketIndex = call.indexOf(40);
        if (openingBracketIndex < 1) {
            return null;
        }
        return call.substring(0, openingBracketIndex);
    }

    private static String parseName(ITypedRegion region, String content, int offset, boolean skipInitialWhitespaces) {
        char ch;
        int i;
        int partitionStart;
        if (content.length() == 0) {
            return null;
        }
        if (offset < 0) {
            return null;
        }
        StringBuffer name = new StringBuffer();
        int start = offset;
        int n = partitionStart = region == null ? 0 : region.getOffset();
        if (skipInitialWhitespaces) {
            i = start;
            while (i >= partitionStart) {
                ch = content.charAt(i);
                if (!Character.isWhitespace(ch)) {
                    start = i;
                    break;
                }
                --i;
            }
        }
        i = start;
        while (i >= partitionStart) {
            ch = content.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) {
                name.insert(0, ch);
            } else if (ch == '\\') {
                name.insert(0, ch);
            } else {
                if (ch == '$') {
                    name.insert(0, ch);
                    return name.toString();
                }
                return name.toString();
            }
            --i;
        }
        return name.toString();
    }

    private static String parseFunctionCall(ITypedRegion region, String content, int offset, boolean skipInitialWhitespaces) {
        if (offset < 0) {
            return null;
        }
        StringBuffer call = new StringBuffer();
        int start = offset;
        if (skipInitialWhitespaces) {
            start = ParsingUtils.skipWhiteSpaces(start, content);
        }
        int state = 0;
        int level = 0;
        int partitionStart = region == null ? 0 : region.getOffset();
        int i = start;
        while (i >= partitionStart) {
            char ch = content.charAt(i);
            switch (state) {
                case 0: {
                    if (ch != ')') {
                        return null;
                    }
                    call.insert(0, ch);
                    state = 1;
                    ++level;
                    break;
                }
                case 1: {
                    if (ch == '(') {
                        call.insert(0, ch);
                        if (--level != 0) break;
                        state = 2;
                        break;
                    }
                    if (ch == ')') {
                        ++level;
                        call.insert(0, ch);
                        break;
                    }
                    call.insert(0, ch);
                    break;
                }
                case 2: {
                    if (Character.isJavaIdentifierPart(ch)) {
                        call.insert(0, ch);
                        break;
                    }
                    if (ParsingUtils.isFunctionCall(call.toString())) {
                        return call.toString();
                    }
                    return null;
                }
            }
            --i;
        }
        if (state != 2) {
            return null;
        }
        if (!ParsingUtils.isFunctionCall(call.toString())) {
            return null;
        }
        return call.toString();
    }

    private static String parseReferenceOperator(ITypedRegion region, String[] possibleOperators, int pos, String contents) {
        String[] stringArray = possibleOperators;
        int n = possibleOperators.length;
        int n2 = 0;
        while (n2 < n) {
            String possibleReference = stringArray[n2];
            if (ParsingUtils.parseConstantString(region, possibleReference, pos, contents) != -1) {
                return possibleReference;
            }
            ++n2;
        }
        return null;
    }

    private static int skipWhiteSpaces(int pos, String contents) {
        if (pos < 0) {
            return pos;
        }
        int i = pos;
        while (i >= 0) {
            if (!Character.isWhitespace(contents.charAt(i))) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private static int parseConstantString(ITypedRegion region, String constant, int start, String contents) {
        if (start < constant.length() - 1) {
            return -1;
        }
        int partitionStart = region == null ? 0 : region.getOffset();
        int posInConstant = constant.length() - 1;
        int i = start;
        while (i >= partitionStart) {
            char constantChar;
            if (posInConstant == -1) {
                return i;
            }
            char contentsChar = contents.charAt(i);
            if (contentsChar != (constantChar = constant.charAt(posInConstant))) {
                return -1;
            }
            --posInConstant;
            --i;
        }
        return -1;
    }

    private ParsingUtils() {
    }
}

